/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpCommon.GraphDataSeriesImpl;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.nhm.eui.NhmHelpRef;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import jclass.chart.JCChartTimeUtil;

public class NhmGraphDetailsDialog
extends Dialog
implements ActionListener,
WindowListener {
    Panel panel;
    Panel details;
    Button ok;
    Button help;
    GraphDataSeriesImpl gds;
    Applet appl;
    private ResourceBundle nhmRes = ResourceBundle.getBundle("ibm.nways.nhm.eui.NhmResources");

    public NhmGraphDetailsDialog(Frame frame, GraphDataSeriesImpl graphDataSeriesImpl, Applet applet) {
        super(frame, graphDataSeriesImpl.getName(), false);
        this.setLayout(new BorderLayout());
        this.appl = applet;
        this.addWindowListener(this);
        this.panel = new Panel(new BorderLayout());
        this.gds = graphDataSeriesImpl;
        this.setData(graphDataSeriesImpl);
        Panel panel = new Panel();
        this.ok = new Button(this.nhmRes.getString("s_ok"));
        this.ok.addActionListener(this);
        panel.add(this.ok);
        this.help = new Button(this.nhmRes.getString("s_Help"));
        this.help.addActionListener(this);
        panel.add(this.help);
        this.panel.add("South", panel);
        this.add("Center", this.panel);
        this.pack();
        ((Component)this).setSize(400, 400);
    }

    public void setData(GraphDataSeriesImpl graphDataSeriesImpl) {
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new GridLayout(0, 1, 0, 0));
        Panel panel3 = new Panel(new GridLayout(0, 1, 0, 0));
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(4);
        NumberFormat numberFormat2 = NumberFormat.getPercentInstance();
        numberFormat2.setMaximumFractionDigits(2);
        panel2.add(new Label(this.nhmRes.getString("s_PollingObject")));
        panel3.add(new Label(graphDataSeriesImpl.getName()));
        panel2.add(new Label(this.nhmRes.getString("s_SelectedDate")));
        panel3.add(new Label(JCChartTimeUtil.timeLabel("%c", graphDataSeriesImpl.getSelectedDateObject())));
        panel2.add(new Label(this.nhmRes.getString("s_SelectedValue")));
        panel3.add(new Label(numberFormat.format(graphDataSeriesImpl.getSelectedValue())));
        panel2.add(new Label(this.nhmRes.getString("s_SelectedPercentage")));
        panel3.add(new Label(numberFormat2.format(graphDataSeriesImpl.getSelectedPercent())));
        panel2.add(new Label(this.nhmRes.getString("s_Average")));
        panel3.add(new Label(numberFormat.format(graphDataSeriesImpl.getAverage())));
        panel2.add(new Label(this.nhmRes.getString("s_MinValue")));
        panel3.add(new Label(numberFormat.format(graphDataSeriesImpl.getMinValue())));
        panel2.add(new Label(this.nhmRes.getString("s_MinDate")));
        panel3.add(new Label(JCChartTimeUtil.timeLabel("%c", graphDataSeriesImpl.getMinDate())));
        panel2.add(new Label(this.nhmRes.getString("s_MaxValue")));
        panel3.add(new Label(numberFormat.format(graphDataSeriesImpl.getMaxValue())));
        panel2.add(new Label(this.nhmRes.getString("s_MaxDate")));
        panel3.add(new Label(JCChartTimeUtil.timeLabel("%c", graphDataSeriesImpl.getMaxDate())));
        panel.add("West", panel2);
        panel.add("Center", panel3);
        if (this.details != null) {
            this.panel.remove(this.details);
        }
        this.details = panel;
        this.panel.add("Center", this.details);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            this.gds.removeDetails();
            return;
        }
        if (actionEvent.getSource() == this.help) {
            NhmHelpRef nhmHelpRef = new NhmHelpRef(this);
            if (this.appl instanceof BrowserApplet) {
                BrowserApplet browserApplet = (BrowserApplet)this.appl;
                browserApplet.showHelp(nhmHelpRef);
                return;
            }
            this.appl.getAppletContext().showDocument(nhmHelpRef.getURL(this.appl));
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.gds.removeDetails();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

